<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

ob_start(); // Start output buffering
require_once("../home/includes/route.php");
require_once("config.php"); // Include your database connection file
session_start();

// Check if the user is logged in
if (isset($_SESSION["loginId"])) {
    

    // Retrieve user information from the database
    $loginId = $_SESSION["loginId"];
    $sqlUser = "SELECT sFname, sWallet, sRefWallet, sType, sNin FROM subscribers WHERE sId = ?";
    $stmtUser = $conn->prepare($sqlUser);

    if (!$stmtUser) {
        die("Error preparing SQL statement for user: " . $conn->error);
    }

    $stmtUser->bind_param("s", $loginId);
    $stmtUser->execute();
    $stmtUser->store_result();
    $stmtUser->bind_result($firstName, $walletBalance, $refBalance, $userType, $nin);

    if ($stmtUser->fetch()) {
        // Handle user input for NIN saving
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $userNIN = $_POST["idNumber"]; // Assuming your input field has name="idNumber"

            // Save the NIN to the database
            $sqlUpdateNIN = "UPDATE subscribers SET sNin = ? WHERE sId = ?";
            $stmtUpdateNIN = $conn->prepare($sqlUpdateNIN);

            if (!$stmtUpdateNIN) {
                die("Error preparing SQL statement for updating NIN: " . $conn->error);
            }

            $stmtUpdateNIN->bind_param("ss", $userNIN, $loginId);
            $stmtUpdateNIN->execute();

            if ($stmtUpdateNIN->error) {
                die("Error updating NIN in the database: " . $stmtUpdateNIN->error);
            }

            $stmtUpdateNIN->close();

            // Redirect to success page upon successful NIN update
            header("Location: kyc-success.php");
            ob_end_flush(); // Flush output buffer and end buffering
            exit();
        }

        $stmtUser->close();
    } else {
        // Handle the case where user information couldn't be retrieved
        echo "User information not available.";
    }

    // Close the database connection
    $conn->close();
} else {
    // Handle the case where the user is not logged in
    echo "User is not logged in.";
}
?>
