<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title>Login</title>

    <!-- PWA manifest link -->
    <link rel="manifest" href="../dashbord/manifest.json">
    <meta name="theme-color" content="#000000">

    <!-- Register the service worker for PWA -->
    <script>
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('../mobile/sw.js')
            .then(function(registration) {
                console.log('Service Worker registered with scope:', registration.scope);
            }).catch(function(error) {
                console.log('Service Worker registration failed:', error);
            });
        }
    </script>

    <link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">
    <link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
    <link rel="icon" type="image/png" href="../../assets/img/favicon.png" />

    <style>
        body { margin: auto; }
        .title-box-container {
            background-image: url("../../assets/img/bg/cover3.jpg");
            background-repeat: no-repeat;
            background-size: cover;
            height: 150px;
            border-bottom-left-radius: 60%;
            border-bottom-right-radius: 60%;
        }
        .title-box-body {
            background-color: #198754;
            height: inherit;
            border-bottom-left-radius: 60%;
            border-bottom-right-radius: 60%;
        }
        .card {
            background: rgba(255, 255, 255, 0.9);
            margin: 20px;
            border-radius: 0px;
        }
        .form-control {
            background-color: #ffffff !important;
            border-radius: 1.5rem !important;
            padding: 25px !important;
            padding-left: 50px !important;
        }
        .form-control:focus {
            background-color: #ffffff !important;
        }
        .input-style i {
            padding-left: 20px !important;
        }
        .btn {
            border-radius: 1.5rem !important;
            background-image: linear-gradient(to bottom, <?php echo $sitecolor; ?>, <?php echo $sitecolor; ?>) !important;
        }
        .color-highlight {
            color: <?php echo $sitecolor; ?> !important;
        }
    </style>
</head>

<body class="theme-light">
    <div id="page">
        <div class="page-content body-container">
            <div class="body-container-child">

                <div class="title-box-container">
                    <div class="title-box-body d-flex justify-content-center align-items-center">
                        <div>
                            <h1 class="text-white text-center"><?php echo $sitename; ?></h1>
                        </div>
                    </div>
                </div>

                <div class="user-top text-center mt-n5">
                    <img src="../../assets/images/icons/user-smile.png" style="border-radius:5rem; width:100px; height:100px; margin-right:10px;">
                    <h1 class="font-25 mt-2 mb-3 color-highlight">LOGIN</h1>
                    <h6 class="mb-1 mt-2 color-highlight" id="accountname">Welcome To <?php echo $sitename; ?></h6>
                </div>

                <div class="">
                    <div class="content">
                        <div class="px-2">
                            <div id="logininputes">
                                <form id="login-form" method="post">
                                    <div class="input-style no-borders has-icon mb-2 mt-2" id="phonediv">
                                        <i class="fa fa-phone"></i>
                                        <input type="number" class="form-control" id="phonelogin" name="phone" placeholder="Phone Number" required />
                                        <label for="phone" class="color-highlight">Phone</label>
                                        <em>(required)</em>
                                    </div>
                                    <div class="input-style no-borders has-icon mb-4">
                                        <i class="fa fa-lock"></i>
                                        <input type="password" class="form-control" id="passwordlogin" name="password" placeholder="Password" required />
                                        <label for="password" class="color-highlight">Password</label>
                                        <em>(required)</em>
                                    </div>

                                    <input type="hidden" id="deviceid" name="device" value="1723476891xlrsFkvJDq963" />

                                    <button type="submit" id="submit-btn" style="width: 100%;" class="btn btn-full btn-l font-600 font-15 gradient-highlight mt-4 ">
                                        Login
                                    </button>
                                </form>
                            </div>

                            <div class="row pt-4 mb-3">
                                <div class="col-12 text-center font-15">
                                    <a class="text-dark" href="../recovery/">Forget Password? Recover It</a>
                                </div>
                                <div class="col-12 text-center font-15 mt-2">
                                    <a class="text-dark" href="../register/">New User? Create Account</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Page content ends here -->
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            //Save Phone Number
            checkIfPhoneNumberSaved();

            //Enable Form Input
            $("#phonelogin").click(function() {
                $(this).removeAttr("readonly");
            });
            $("#passwordlogin").click(function() {
                $(this).removeAttr("readonly");
            });

            //Login Form
            $('#login-form').submit(function(e) {
                e.preventDefault();
                $('#submit-btn').removeClass("btn-primary");
                $('#submit-btn').addClass("btn-secondary");
                $('#submit-btn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');

                $.ajax({
                    url: '../dashboard/includes/route.php?login',
                    data: new FormData($(this)[0]),
                    cache: false,
                    contentType: false,
                    processData: false,
                    method: 'POST',
                    type: 'POST',
                    success: function(resp) {
                        resp = JSON.parse(resp);
                        if (resp.status == "success") {
                            swal('Alert!!', "Login Successful", "success");
                            setTimeout(function() {
                                location.replace('../dashboard/')
                            }, 1000);
                        } else {
                            swal('Alert!!', resp.msg, "error");
                        }
                        $('#submit-btn').removeClass("btn-secondary");
                        $('#submit-btn').addClass("btn-primary");
                        $('#submit-btn').html("<b>Login</b>");
                    }
                });
            });
        });

        function checkIfPhoneNumberSaved() {
            $phone = atob(unescape(getCookie("loginPhone")));
            $name = atob(unescape(getCookie("loginName")));
            if ($phone != null && $phone != "") {
                let msg = '<p class="mb-3"><a href="javascript:showNumber();"><b class="text-primary">Login With Another Account?</b></a></p>';
                $("#accountname").after(msg);
                $("#accountname").append(" " + $name + "!");
                $("#phonediv").hide();
                $("#phonelogin").val($phone);
            }
        }

        function showNumber() {
            $("#phonediv").show();
        }

        function getCookie(cname) {
            var name = cname + "=";
            var ca = document.cookie.split(';');
            for (var i = 0; i < ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') c = c.substring(1);
                if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
            }
            return "";
        }
    </script>
</body>

</html>