<?php

class BulkSMS extends ApiAccess {

    // Purchase Bulk SMS Data
    public function purchaseBulkSMS($body) {
        $response = array();
        $details = $this->model->getApiDetails();
        
        // API Details
        $host = "https://bilalsadasub.com/api/bulksms";
        $apiKey = "c3VudXNpa2lydTpARG9udGVjaDgya2lydQ==";  // Replace with your actual API Token
        $hostuserurl = "https://bilalsadasub.com/api/user/";

        // Check API Domain (n3tdata247, bilalsadasub, beensade)
        if (strpos($host, 'n3tdata247') !== false) {
            $hostuserurl = "https://n3tdata247.com/api/user/";
            return $this->purchaseDataWithBasicAuthentication($body, $host, $hostuserurl, $apiKey);
        }

        if (strpos($host, 'beensade') !== false) {
            $hostuserurl = "https://beensadeprint.com/api/user/";
            return $this->purchaseDataWithBasicAuthentication($body, $host, $hostuserurl, $apiKey);
        }

        return $this->purchaseDataWithAuthorization($body, $host, $apiKey);
    }

    // Send Purchase Data Request With Basic Authentication
    public function purchaseDataWithBasicAuthentication($body, $host, $hostuserurl, $apiKey) {
        $response = array();
        
        // Get User Access Token
        $accessToken = $this->getAccessToken($hostuserurl, $apiKey);
        if (!$accessToken) {
            $response["status"] = "fail";
            $response["msg"] = "Failed to get Access Token.";
            return $response;
        }

        // Purchase Data Request
        return $this->sendSMS($body, $host, $accessToken);
    }

    // Send Purchase Data Request with Token Authorization
    public function purchaseDataWithAuthorization($body, $host, $apiKey) {
        return $this->sendSMS($body, $host, $apiKey);
    }

    // Get Access Token from API
    private function getAccessToken($url, $apiKey) {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => 1,
            CURLOPT_HTTPHEADER => array(
                "Authorization: Basic $apiKey",
            ),
        ));
        
        $exereq = curl_exec($curl);
        $err = curl_error($curl);
        if ($err) {
            file_put_contents("basic_error_log.txt", json_encode(array("status" => "fail", "msg" => "Server Connection Error")) . "\n" . $err);
            curl_close($curl);
            return false;
        }

        $result = json_decode($exereq);
        curl_close($curl);

        return $result->AccessToken ?? false;
    }

    // Send SMS via API
    private function sendSMS($body, $host, $apiKey) {
        $response = array();

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $host,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => 1,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                "Authorization: Token $apiKey"  // Authorization token for API access
            ),
            CURLOPT_POSTFIELDS => json_encode(array(
                "sender" => $body->sender,  // Sender's name
                "message" => $body->message,  // Message content
                "phonenumber" => $body->phone  // Recipient's phone number
            )),
        ));

        $exereq = curl_exec($curl);
        $err = curl_error($curl);
        if ($err) {
            $response["status"] = "fail";
            $response["msg"] = "Service not available - Server Connection Error";
            file_put_contents("data_error_log.txt", json_encode($response) . " " . $err . " " . $host);
            curl_close($curl);
            return $response;
        }

        $result = json_decode($exereq);
        curl_close($curl);

        if ($result->status == 'success' || $result->status == 'processing') {
            $response["status"] = "success";
            $response["amount"] = $result->amount;
            $response["total_number"] = $result->total_number;
            $response["total_correct_number"] = $result->total_correct_number;
            $response["total_wrong_number"] = $result->total_wrong_number;
            $response["message"] = $result->message;
            $response["sender_name"] = $result->sender_name;
            $response["numbers"] = $result->numbers;
        } elseif ($result->status == 'failed') {
            $response["status"] = "fail";
            $response["msg"] = "Service not available - Network Error, Please try again later.";
        } else {
            $response["status"] = "fail";
            $response["msg"] = "Server/Network Error: " . $result->msg;
            file_put_contents("data_error_log.txt", json_encode($result));
        }

        return $response;
    }
}
?>